/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.ArrayList;
import java.util.List;

public class AnimationStack
implements IAnimation {
    private final List<Pair<Integer, IAnimation>> layers = new ArrayList<Pair<Integer, IAnimation>>();

    @Override
    public boolean isActive() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            layer.getRight().tick();
        }
    }

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            if (!layer.getRight().isActive()) continue;
            value0 = layer.getRight().get3DTransform(modelName, type, tickDelta, value0);
        }
        return value0;
    }

    @Override
    public void setupAnim(float tickDelta) {
        for (Pair<Integer, IAnimation> layer : this.layers) {
            layer.getRight().setupAnim(tickDelta);
        }
    }

    public void addAnimLayer(int priority, IAnimation layer) {
        int search;
        for (search = 0; this.layers.size() > search && this.layers.get(search).getLeft() < priority; ++search) {
        }
        this.layers.add(search, new Pair<Integer, IAnimation>(priority, layer));
    }

    public boolean removeLayer(IAnimation layer) {
        return this.layers.removeIf(integerIAnimationPair -> integerIAnimationPair.getRight() == layer);
    }

    public boolean removeLayer(int layerLevel) {
        return this.layers.removeIf(integerIAnimationPair -> (Integer)integerIAnimationPair.getLeft() == layerLevel);
    }
}

